#include <bits/stdc++.h>
using namespace std;

const int MAX_N = 1e6 + 5, MAX_NX = 15e5 + 5, MAX_LOG = 22;
vector<int> adj[MAX_N], tree[MAX_N], compressed[MAX_N];
vector<pair<int, bool>> updates[MAX_N];

int depth[MAX_NX], root[MAX_NX], left_child[MAX_NX * MAX_LOG], right_child[MAX_NX * MAX_LOG];
int segment_tree[MAX_NX * MAX_LOG], ancestors[MAX_LOG][MAX_NX], edge_count[MAX_N];
int component[MAX_N], value[MAX_N], component_count, node_count = 1, nodes;
bool visited[MAX_N];
int update_index = 0;

void modify_tree(int old_root, int new_root, vector<pair<int, bool>>& mods, int left = 0, int right = -1) {
    if (right == -1) right = nodes - 1;
    if (left == right) {
        segment_tree[new_root] = segment_tree[old_root];
        while (update_index < mods.size() && mods[update_index].first == left) {
            segment_tree[new_root] += mods[update_index].second ? 1 : -1;
            ++update_index;
        }
        return;
    }
    int mid = (left + right) / 2;
    if (update_index < mods.size() && mods[update_index].first <= mid) {
        left_child[new_root] = ++node_count;
        modify_tree(left_child[old_root], left_child[new_root], mods, left, mid);
    } else {
        left_child[new_root] = left_child[old_root];
    }
    if (update_index < mods.size()) {
        right_child[new_root] = ++node_count;
        modify_tree(right_child[old_root], right_child[new_root], mods, mid + 1, right);
    } else {
        right_child[new_root] = right_child[old_root];
    }
    segment_tree[new_root] = segment_tree[left_child[new_root]] + segment_tree[right_child[new_root]];
}

int construct_tree(int left = 0, int right = -1) {
    if (right == -1) right = nodes - 1;
    if (left == right) return ++node_count;
    int mid = (left + right) / 2, node = ++node_count;
    left_child[node] = construct_tree(left, mid);
    right_child[node] = construct_tree(mid + 1, right);
    return node;
}

void explore(int node, int parent = -1) {
    visited[node] = true;
    for (int neighbor : adj[node]) {
        if (neighbor == parent) continue;
        if (visited[neighbor]) {
            int high = node, low = neighbor;
            if (depth[high] < depth[low]) swap(high, low);
            edge_count[high]++, edge_count[low]--;
            continue;
        }
        depth[neighbor] = depth[node] + 1;
        tree[node].push_back(neighbor);
        tree[neighbor].push_back(node);
        explore(neighbor, node);
    }
}

void propagate_edge_count(int node, int parent = -1) {
    for (int child : tree[node]) {
        if (child == parent) continue;
        propagate_edge_count(child, node);
        edge_count[node] += edge_count[child];
    }
}

void compress_tree(int node, int parent = -1) {
    for (int child : tree[node]) {
        if (child == parent) continue;
        if (edge_count[child]) {
            component[child] = component[node] ? component[node] : ++component_count;
        }
        compress_tree(child, node);
    }
    if (component[node] && parent != -1) {
        int new_node = ++component_count;
        compressed[node].push_back(new_node);
        compressed[new_node].push_back(node);
        compressed[new_node].push_back(component[node]);
        compressed[component[node]].push_back(new_node);
        updates[component[node]].push_back({value[node], true});
        updates[new_node].push_back({value[node], false});
        updates[node].push_back({value[node], true});
    } else if (parent != -1) {
        compressed[node].push_back(parent);
        compressed[parent].push_back(node);
    }
}

void build_persistent_tree(int node, int parent = 0) {
    root[node] = ++component_count;
    update_index = 0;
    modify_tree(root[parent], root[node], updates[node]);
    for (int child : compressed[node]) {
        if (child == parent) continue;
        ancestors[0][child] = node, depth[child] = depth[node] + 1;
        build_persistent_tree(child, node);
    }
}

int find_ancestor(int node, int k) {
    for (int i = MAX_LOG - 1; i >= 0; --i) {
        if ((k >> i) & 1) node = ancestors[i][node];
    }
    return node;
}

int find_lca(int u, int v) {
    if (depth[u] < depth[v]) swap(u, v);
    u = find_ancestor(u, depth[u] - depth[v]);
    if (u == v) return u;
    for (int i = MAX_LOG - 1; i >= 0; --i) {
        if (ancestors[i][u] != ancestors[i][v]) {
            u = ancestors[i][u];
            v = ancestors[i][v];
        }
    }
    return ancestors[0][u];
}

int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);
    int edges, queries, P;
    cin >> nodes >> edges >> queries >> P;
    component_count = nodes;
    vector<int> unique_values;
    for (int i = 1; i <= nodes; ++i) {
        cin >> value[i];
        unique_values.push_back(value[i]);
    }
    sort(unique_values.begin(), unique_values.end());
    unique_values.erase(unique(unique_values.begin(), unique_values.end()), unique_values.end());
    for (int i = 1; i <= nodes; ++i) {
        value[i] = lower_bound(unique_values.begin(), unique_values.end(), value[i]) - unique_values.begin();
    }
    for (int i = 1; i <= edges; ++i) {
        int u, v;
        cin >> u >> v;
        adj[u].push_back(v);
        adj[v].push_back(u);
    }
    explore(1);
    propagate_edge_count(1);
    compress_tree(1);
    root[0] = construct_tree();
    build_persistent_tree(1);
    for (int i = 1; i < MAX_LOG; ++i) {
        for (int j = 1; j <= nodes; ++j) {
            ancestors[i][j] = ancestors[i-1][ancestors[i-1][j]];
        }
    }
    while (queries--) {
        int u, v;
        cin >> u >> v;
        int lca = find_lca(u, v);
        int result = segment_tree[root[u]] + segment_tree[root[v]] - segment_tree[root[lca]] - segment_tree[root[ancestors[0][lca]]];
    }
}